using System;
using System.IO;

public class Program
{
  public static void Main(String[] args)
  {
    if(args.Length < 1)
    {
      Console.WriteLine("Wywołanie programu: Program plik");
      return;
    }
    String plik = args[0];
    int ile = 100;

    FileStream fs;
    try
    {
      fs = new FileStream(plik, FileMode.Create);
    }
    catch(Exception)
    {
      Console.WriteLine("Otwarcie pliku {0} nie powiodło się.", plik);
      return;
    }

    BinaryWriter bw = new BinaryWriter(fs);

    try
    {
      bw.Write(ile);
      for(int i = 1; i <= ile; i++)
      {
        bw.Write(i);
      }
    }
    catch(Exception)
    {
      Console.WriteLine("Wystąpił błąd w trakcie zapisu danych.");
      return;
    }
    bw.Close();
    Console.WriteLine("Zapis został dokonany.");
  }
}
